; UHF Repeater

	ERRORLEVEL -302
	ERRORLEVEL -306

	list P=16F88
	#include p16f88.inc

;Program Configuration Register 1
		__CONFIG    _CONFIG1, _CP_OFF & _CCP1_RB3  & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_OFF & _MCLR_ON & _PWRTE_ON & _WDT_OFF & _INTRC_IO

;Program Configuration Register 2
		__CONFIG    _CONFIG2, _IESO_OFF & _FCMEN_OFF


; Define variables at memory locations

; Bank 0 RAM

RATE			equ H'20'	; data rate
RETRANS		equ H'21'	; Delay for ignoring received signal after repeater transmission	
STORE1			equ H'22'	; delay counter	
STORE2			equ H'23'	; delay counter
STORE3			equ	H'24'	; delay counter	
RATE_COUNT0	equ	H'25'	; rate value to compare with counter 1 ms byte
RATE_COUNT1	equ	H'26'	; rate value to compare with counter 1 ls byte 
START			equ	H'27'	; data reading started
EDGE			equ	H'28'	; edge interrupt flag
ADDRESS0		equ H'29'	; memory address ms byte
ADDRESS1		equ H'2A'	; memory address ls byte
RD_ADDRES0	equ	H'2B'	; read address when reading data for transmitter ms byte
RD_ADDRES1	equ	H'2C'	; read address when reading data for transmitter ls byte
RD_WRT		equ	H'2D'	; store either a read or write instruction for memory
SHIFT0			equ	H'2E'	; data bits ms byte for data read from memory
SHIFT1			equ	H'2F'	; data bits ls byte
TEMP			equ	H'30'	; temporary
TMPH			equ	H'31'	; temporary timer1 value
TMPL			equ	H'32'	; temporary timer1 value
DATA_COUNT	equ	H'33'	; counter for number of data levels stored before deemed valid

; all banks 
W_TMP			equ	H'70'	; storage of w before interrupt
STATUS_TMP	equ	H'71'	; status storage before interrupt
COUNT0		equ	H'72'	; timer1 ms byte
COUNT1		equ	H'73'	; timer1 ls byte
DATA_VAL		equ	H'74'	; data value	

; Math routine registers
AARGB0		equ	H'7B'	; ms multiplier
AARGB1		equ	H'7C'	; ls multiplier
BARGB0		equ	H'7D'	; ms multiplier
BARGB1		equ	H'7E'	; ms multiplier
LOOPCOUNT	equ	H'7F'	; counter

	org	0	
	goto	MAIN
	org 4

INTERRUPT
; provides counter value and sets interrupt flag (EDGE,0)

; start interrupt by saving w and status registers  
	movwf	W_TMP			; w to w_tmp storage
	swapf	STATUS,w		; status to w
	movwf	STATUS_TMP	; status in status_tmp 
	bcf		STATUS,RP0	; bank 0
	bcf		STATUS,RP1

	btfsc	INTCON,RBIF	; switch pressed (port change RB5)
	goto	SWITCH			; interrupt due to switch?
; stop timer and store
	bcf		T1CON,0
	movf	TMR1H,w
	movwf	COUNT0
	movf	TMR1L,w
	movwf	COUNT1
; clear timer
	clrf		TMR1H
	clrf		TMR1L
; restart timer
	bsf		T1CON,0

; set interrupt edge 
	bsf		STATUS,RP0		; bank 1
	btfsc	OPTION_REG,6		; INTEDG
	goto	CLR_REG
; set interrupt for high going edge
	bsf		OPTION_REG,6
	goto	SET_FLAG
CLR_REG
	bcf		OPTION_REG,6
SET_FLAG
	bcf		STATUS,RP0		; bank 0
SET_FLAG1
	bsf		EDGE,0				; set flag to indicate interrupt
	bcf		INTCON,INTF			; interrupt flag cleared

RECLAIM 	;get w and status
	swapf	STATUS_TMP,w	; status temp storage to w
	movwf	STATUS			; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf   	W_TMP,w		; swap bits and into w register
	retfie					; return from interrupt

; check if S1 pressed
SWITCH
	btfss	INTCON,RBIF		; if edge interrupt, then S1 pressed (RB5 low)
	goto	RECLAIM			; end interrupt
KEEP_READ
	call		ANALOGUE			; get trimpot values
; wait for switch open
	btfss	PORTB,5
	goto	KEEP_READ
	movf	PORTB,f
	bcf		INTCON,RBIF
	goto	RECLAIM

; *************************************************
MAIN
; set inputs/outputs
	clrf		PORTB		; portb 
	clrf		PORTA		; porta
	nop
; memory off
	bsf		PORTB,3	; CS bar high for memory

	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	movlw	B'00100011'	; I/O (RB outputs)
	movwf	TRISB		; port B data direction register
	movlw	B'10000000'	; 
	movwf	OPTION_REG	; pullups disabled 
	movlw   B'00100011'	; I/O 
	movwf   TRISA		; port A data direction register
; analog inputs, A/D
	movlw	B'00000011'	; AN0,AN1 analog input 
	movwf	ANSEL
	movlw	B'01000000'	; left justified A/D result, Vdd to Vss A/D
	movwf	ADCON1
	bcf		STATUS,RP0	; select memory bank 0
	movlw	B'01000000'	; Fosc, channel 0 
	movwf	ADCON0
; oscillator
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'01110000'		; for 8MHz
	movwf	OSCCON		; osc
	bcf		STATUS,RP0	; select memory bank 0
;Timer1 on
	movlw 	B'00110000'		; divide by 8 for 4us per count
	movwf	T1CON
; start timer
	bsf		T1CON,0
; SPI
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'11000000'		; 
	movwf	SSPSTAT
	bcf		STATUS,RP0	; select memory bank 0
	movlw	B'00000000'
	movwf	SSPCON		; bit 5 enables SPI when set
	nop
	bsf		SSPCON,5		; enable SPI

; enable interrupt
	
	bsf		STATUS,RP0	; select memory bank 1
	bcf		STATUS,RP0	; select memory bank 0
	bcf		PIR1,TMR1IF		; timer 1 overflow flag
	bcf		INTCON,INTF		; edge interrupt flag
	movf	PORTB,w		; read to allow clear of edge interrupt flag
	bcf		INTCON,RBIF	; port change interrupt for switch
	bsf		INTCON,RBIE	; port change interrupt enabled
	bsf		INTCON,GIE

RUN
	clrf		START			; start flag cleared for start of memory
	call		ANALOGUE		; get VR1 and VR2 values using A/D converter
	goto	LOOP1			; bypass retransmission delay on power up

; memory off LEDs off
MEM_LEDS_OFF
	bsf		PORTB,3	; CS bar for memory
	nop
	nop
	bcf		PORTB,7	; transmit LED off
	nop
	nop
	bcf		PORTB,6	; receive LED off
	return

LOOP_STRT
; memory off, LEDs off
	call		MEM_LEDS_OFF

;..............................................................................
;  add delay for reading data after transmission.  RETRANS is delay value  50ms to 12.5s 
; delay adjusted with VR2
	movf	RETRANS,w
	call		DELAYX
	goto	LOOP2
;.............................................................................

LOOP1
; memory off, LEDs off
	call		MEM_LEDS_OFF
LOOP2
	clrf		START
; edge interrupt off
	bcf		INTCON,INTE
	bcf		INTCON,INTF
; set interrupt for high going edge
	bsf		STATUS,RP0
	bsf		OPTION_REG,6		; INTEDG
	bcf		STATUS,RP0
	bcf		INTCON,INTF

; wait for edge interrupt flag  INTF
WAIT_HI
	btfss	INTCON,INTF
	goto	WAIT_HI
	bcf		INTCON,INTF
;  start timer1
; clear timer
	clrf		TMR1L
	clrf		TMR1H

; set edge for low going edge
	bsf		STATUS,RP0
	bcf		OPTION_REG,6		; INTEDG
	bcf		STATUS,RP0
	bcf		INTCON,INTF

; keep monitoring 

WAIT_HI1
	btfss	INTCON,INTF
	goto	WAIT_HI1
; check timer 1. If > RATE_COUNT, then start storing (and set START,0)
; set interrupt edge for a low and enable edge interrupt and clear EDGE

; initial setup
; compare timer  (TMR1H, TMR1L with RATE_COUNT0, RATE_COUNT1)
; read timer first

; stop timer
	bcf		T1CON,0
	movf 	TMR1H,w 	; Read high byte
	movwf	TMPH
	movf  	TMR1L,w 	; Read low byte
	movwf 	TMPL
; start timer
	bsf		T1CON,0	

	movf	TMPH,w				; timer counter value ms byte
	subwf	RATE_COUNT0,w
	movwf	TEMP
	movf	TMPL,w				; timer counter value ls byte	
	subwf	RATE_COUNT1,w
	btfss	STATUS,C			; if ls byte is greater
	decf	TEMP,f

	btfss	TEMP,7				; if set then timer count (TMR1H,TMR1L>RATE_COUNT0,1) ; if level stays low or high longer than max rate then,

	goto	LOOP2				; detecting noise signal so end of data
	bsf		EDGE,0				

	movlw	D'5'
	movwf	DATA_COUNT		; set at several data levels before deemed valid
	movlw	H'66'				; initial memory address location ms byte
	movwf	FSR

	bsf		INTCON,INTE		; enable interrupt


; Read RB0 (receive data). Data rate needs to be less than RATE for up to 5kbps. If more, then assumed to be noise due to raised AGC level of receiver
EDGE_WAIT	
 
; wait for edge interrupt
	btfss	EDGE,0			; bit 0 set in interrupt
	goto	EDGE_WAIT
	clrf		EDGE

; check level
CK_LEV
	bcf		INTCON,GIE	
	clrf		EDGE
	bcf		DATA_VAL,0
	bsf		STATUS,RP0;
	btfss	OPTION_REG,6		; if interrupt edge was high going then RB0 was low 	
	bsf		DATA_VAL,0		; set data
	bcf		STATUS,RP0
	
; compare timer  (COUNT0, COUNT1 with RATE_COUNT0, RATE_COUNT1)
	
	movf	COUNT0,w			; counter value ms byte	
	subwf	RATE_COUNT0,w
	movwf	TEMP
	movf	COUNT1,w			; counter value ls byte	
	subwf	RATE_COUNT1,w
	btfss	STATUS,C			; if ls byte is greater
	decf	TEMP,f

	bsf		INTCON,GIE
	btfss	TEMP,7				; if set then timer count (COUNT0,COUNT1>RATE_COUNT0,1) ; if level stays low or high longer than max rate then,
; 
	goto	TRANSMIT			; detecting noise signal so end of data


STRT_DATA

	bsf		PORTB,6			; receive LED on

	btfsc	START,0			; when started
	goto	WRITE_LED

; add counter for  several  valid data levels received before any transmission
	decfsz	DATA_COUNT,f
	goto	NO_START
	bsf		START,0			; start flag set when valid data

; setup memory for write
; memory set with write mode and address zero
	movlw	D'02'				; write instruction
	movwf	RD_WRT
	call		CLR_MEM			; setup memory to start at 00. 
; write address cleared
	clrf		ADDRESS0			; address 0
	clrf		ADDRESS1

;  recall during transmit the local (in PIC memory) stored bytes 
	goto	WRITE_LED

NO_START; not yet a valid data set until DATA_COUNT reduces to zero, then START flag is set

; store in local memory the data and duration until DATA_COUNT is zero.

; get level
	bcf		COUNT0,7		; clear for data bit
	btfss	DATA_VAL,0
	bsf		COUNT0,7		; set  for data if set
	movf	COUNT0,w		; counter	ms byte	
	movwf	INDF
	incf		FSR,f

	movf	COUNT1,w		; counter	ls byte	
	movwf	INDF
	incf		FSR,f
	goto	EDGE_WAIT				; continue


WRITE_LED

;	bsf		PORTB,6		; receive LED on

; write to memory
; data bit (DATA_VAL,0 and duration (COUNT0, COUNT1) are stored in memory

; For duration, a 4us counter would give a count of 50 at 200us bit level duration. At 32.768 counts for 15 bits gives 131ms of each data bit length
; data stored as 16 bits with ms bit (bit 15) the data level and remaining bits (14 to 0) the time period at that level
; assuming a 5kbps data rate and with 32k of memory (16 bit wide), that is 6.4s minimum of data storage     
; stop when data is at a faster rate than max.
; Replay when reception ended.
	call		DATA_WRITE
	goto	EDGE_WAIT				; continue

;.............................................................................................................................................................................................

TRANSMIT; send data
	bcf		INTCON,INTE	; stop interrupt
; check if started. If not bypass transmission
	movf	START,w
	btfsc	STATUS,Z
	goto	LOOP1
	clrf		START
; light transmit LED
	bsf		PORTB,3	; CS bar for memory
	nop
	bcf		PORTB,6	; receive LED off

;...............................................................................................................
;**** test
; add in delay here for testing repeater so transmitter and receiver can be at one location and repeater located away. Delay allows retransmission after a period
; to test range 
;	movf	RETRANS,w	; using VR2 setting
;	call		DELAYX
; end test
;...............................................................................................................


; RA4 low for data in transmission
; start transmitter power RA2,RA3 high and Transmit LED on
	movlw	B'00001100'
	movwf	PORTA
	bsf		PORTB,7	; transmit LED on

;  code for read
	movlw	D'03'				; read instruction
	movwf	RD_WRT
	call		CLR_MEM			; setup memory to start at 00. Address cleared

; read address cleared
	clrf		RD_ADDRES0			; address 0
	clrf		RD_ADDRES1

; initialise start of local memory pointer
	movlw	H'66'
	movwf	FSR

RD_DATA_LOOP	
; read data from memory

;  initially use the local memory until FSR is >H6D
	movf	FSR,w
	xorlw	H'6E'
	btfsc	STATUS,Z
	goto	MEM_XTRA
; load data from local memory into SHIFT0,SHIFT1
	movf	INDF,w
	movwf	SHIFT0
	incf		FSR,F
	movf	INDF,w
	movwf	SHIFT1
	incf		FSR,F
	goto	MEM_LOCAL
 

MEM_XTRA
	call		RD_DATA

; transmit up to when data is invalid at end when noise detected. Ends at ADDRESS0,1
; check ADDRESS against that used in write 
	movf	RD_ADDRES0,w		; read address value ms byte	
	subwf	ADDRESS0,w		; write address
	movwf	TEMP
	movf	RD_ADDRES1,w		; read address byte	
	subwf	ADDRESS1,w
	btfss	STATUS,C			; if ls byte is greater
	decf	TEMP,f
	btfsc	TEMP,7				; if set then read address>write address so stop
	goto	END_TRANS		; end data transmission. Power off transmitter and memory

MEM_LOCAL
	bsf		PORTB,7	; transmit LED on

; RA4 level set for data in transmission
	btfsc	SHIFT0,7			; read bit 15 (bit 7 in MS byte) for output level
	goto	SET4
	bcf		PORTA,4
	goto	A_SET
SET4
	bsf		PORTA,4
A_SET
	bcf		SHIFT0,7			; clear bit 15 (the data bit0 for timer value
; subtract the 15 bit timer from FFFF. Load timer1 and use data level until timer1 times out

	clrf		TMR1L 			; Clear Low byte, Ensures no rollover into TMR1H
	bcf		T1CON,TMR1ON	; timer off
	movf	SHIFT1,w		; low byte
	sublw	H'07'			; low byte subtract ( value used differs from FFFF to compensate for code run while timer is stopped)
	movwf	TMR1L			; timer 1 low byte
	movf	SHIFT0,w		; high byte
	btfss   	STATUS,C    	 	; carry check
  	addlw   	D'1'       		 	; add one if carry
	sublw	H'00'			; w has high byte subtraction
	movwf	TMR1H
	
	bsf		T1CON,TMR1ON	; timer on
	bcf		PIR1,TMR1IF		; timer 1 interrupt flag cleared

; wait for timer to overflow
TM1	
	btfss	PIR1,TMR1IF
	goto	TM1

	goto	RD_DATA_LOOP		; get next data and increase read address and compare with write address. 

; only transmit stored data (ADDRESS0,1 has max address)

; ending transmit
END_TRANS
	movlw	B'11100011'
	andwf	PORTA,f		; Power off transmitter via RA2,RA3  and RA4 for data low
	bsf		PORTB,3	; memory off
	nop
	bcf		PORTB,7	; transmit LED off

	clrf		START
	bsf		INTCON,GIE	
	goto	LOOP_STRT	; set up for write and clear memory

;________________________________

; subroutines

CLR_MEM			; setup memory to start at 0
	bsf		PORTB,3	; memory CS off

; memory powers up in sequential mode
	
	nop
	nop
	nop
	bcf		PORTB,3	; CS bar for starting up memory chip
	nop
;  issue WRITE instruction (H02)  or READ (03) then ADDRESS (00),
	movf	RD_WRT,w		
	movwf	SSPBUF
	bsf		STATUS,RP0
FLAGACLR	
	btfss	SSPSTAT,BF
	goto	FLAGACLR
	bcf		STATUS,RP0

; issue memory address (000000) (24-bit address) for 1024byte memory (use 16 bit address for 512byte memory)
; 8-bits
	clrf		SSPBUF
	bsf		STATUS,RP0
FLAGBCLR	
	btfss	SSPSTAT,BF
	goto	FLAGBCLR
	bcf		STATUS,RP0
; 16 bits
	clrf		SSPBUF

	bsf		STATUS,RP0
FLAGCCLR	
	btfss	SSPSTAT,BF
	goto	FLAGCCLR
	bcf		STATUS,RP0
; **
;	return	; place a 'return' here for 16-bit address (512 byte memory) ie delete semicolon ahead of return

; required for 1024 byte memory 24 bits 
	clrf		SSPBUF
	bsf		STATUS,RP0
FLAGDCLR	
	btfss	SSPSTAT,BF
	goto	FLAGDCLR
	bcf		STATUS,RP0
	return
; ..........................................................................................................................................................

DATA_WRITE ; write to memory
; issue data over 16 bits

; get level
	bcf		COUNT0,7		; clear for data bit
	btfss	DATA_VAL,0
	bsf		COUNT0,7		; set  for data if set
	movf	COUNT0,w		; counter	ms byte	
	movwf	SSPBUF
	bsf		STATUS,RP0
FLAGA	
	btfss	SSPSTAT,BF
	goto	FLAGA
	bcf		STATUS,RP0
	movf	COUNT1,w		; counter	ls byte	
	movwf	SSPBUF
	bsf		STATUS,RP0
FLAGB
	btfss	SSPSTAT,BF
	goto	FLAGB
	bcf		STATUS,RP0

; increment ADDRESS0,1
	movlw	D'01'
	addwf	ADDRESS1,f		; ls byte address plus 1
	btfsc	STATUS,C
	incfsz	ADDRESS0,f		; increase address if carry on overflow
	return
	movlw	H'FF'
	movwf	ADDRESS0
	movwf	ADDRESS1
	return
;.............................................................................................

; read Data from memory
; data bytes from RB1 read and start with clocking
; get 16-bit value. Bit 15 is data level
RD_DATA

; enable SPI

	clrf		SSPBUF		; load with anything

	bsf		STATUS,RP0
FLAGAR	
	btfss	SSPSTAT,BF
	goto	FLAGAR
	bcf		STATUS,RP0

	movf	SSPBUF,w		; memory value
	movwf	SHIFT0			; ms byte	

	clrf		SSPBUF		; load with anything

	bsf		STATUS,RP0
FLAGBR	
	btfss	SSPSTAT,BF
	goto	FLAGBR
	bcf		STATUS,RP0
	movf	SSPBUF,w
	movwf	SHIFT1			; ls byte	

; increment ADDRESS0,1
	movlw	D'01'
	addwf	RD_ADDRES1,f		; ls byte address plus 1
	btfsc	STATUS,C
	incfsz	RD_ADDRES0,f		; increase address if carry on overflow
	return
	movlw	H'FF'
	movwf	RD_ADDRES1
	movwf	RD_ADDRES0
	return
;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

ANALOGUE; (get VR1 and VR2 values)

;  RA6 and RA7 high to power VR1 and VR2
	movlw	B'11000000'
	movwf	PORTA
	bsf		PORTB,6		; light receive and send LEDs as acknowledgement
	nop
	nop
	bsf		PORTB,7

; read AN0 for reception Ignore delay. VR2 setting.	(ie ignores data for a period after retransmitting data so it will ignore signal from a second repeater.)
	movlw	B'01000000'		; Fosc, channel 0  etc
	movwf	ADCON0
	bsf		ADCON0,0		; a/d on
	call		ACQUIRE_AD	; result: ADRESH 
	movwf	RETRANS

; make sure it is not 0
	movf	RETRANS,f
	btfsc	STATUS,Z
	incf		RETRANS,f		; from 0 to 1 ; 1-255 for delay  (20ms to 5s)

; read AN1 for transmission rate
	movlw	B'01001000'		; Fosc, channel 1  etc
	movwf	ADCON0
	call		ACQUIRE_AD	; result: ADRESH in w
	bcf		ADCON0,0		; a/d off

	movlw	D'174'
	movwf	RATE
	comf	RATE,f			; reverse value so clockwise rotation of trim pot gives a lower peroid value

; convert RATE to 512  range. (x2)

	clrf		RATE_COUNT0	; ms byte cleared first
	movf	RATE,w
	movwf	RATE_COUNT1
	bcf		STATUS,C
	rlf		RATE_COUNT1,f
	rlf		RATE_COUNT0,f

; use 25 as minimum. That is a counter value at 4us per count for 25 counts for 100us. 
; add 25 to RATE for 554 maximum for 2.14ms
	
	movlw	D'25'
	addwf	RATE_COUNT1,f	; rate value to compare with counter 1 ls byte 
	btfsc	STATUS,C		; if carry increase ms byte
	incf		RATE_COUNT0,f	; rate value to compare with counter 1 ms byte

; RA6 and RA7 low to unpower VR1 and VR2
	clrf		PORTA

	bcf		PORTB,6		; LEDs off
	nop
	nop
	bcf		PORTB,7
	return	

;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

; subroutine to wait for A/D conversion
ACQUIRE_AD
	bsf		ADCON0,ADON	; A/D on
	movlw	D'1'
	movwf	STORE3
	call		DELAY1
	bsf		ADCON0,2	; GO/DONE bit start conversion
WAIT_CONV
	btfsc	ADCON0,2	; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV
	bcf		ADCON0,ADON	; A/D off
	movf	ADRESH,w
	return
;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
DELAYX
	movwf	STORE3
DELAY1
	movlw	D'166'	; 
DELAY2
	movwf	STORE1
LOOPB
	movlw	D'200'
	movwf	STORE2
LOOPA
	decfsz	STORE2,f
	goto	LOOPA
	decfsz	STORE1,f
	goto	LOOPB
	decfsz	STORE3,f
	goto	DELAY1
	return


	end